IF EXISTS (SELECT * FROM SYS.views WHERE NAME = 'V_EST_PROD_IMPOSTOS')
BEGIN
	DROP VIEW V_EST_PROD_IMPOSTOS;
END
GO
--select top 10 * from V_EST_PROD_IMPOSTOS where cd_prod = 100
CREATE VIEW [dbo].[V_EST_PROD_IMPOSTOS] AS 
SELECT	
		 PROD.CD_EMP,
	     PROD_CPL.CD_FILIAL,
		 PROD.CD_PROD
		,CASE WHEN (COALESCE(TRIB.SUBS_TRIB_ANT, 0) + COALESCE(TRIB.SUBS_TRIB, 0) + COALESCE(TRIB.ISENTO, 0)) > 0 
					THEN	0
					ELSE
							coalesce(PROD_TRIB.PERC_ICMS_EST,0)
		END	AS ICMS_VENDA
		,CASE WHEN B.PROD_PIS_COFINS = 1 THEN (B.PERC_PIS+B.PERC_COFINS) ELSE 0 END AS PERC_PIS_COFINS
		,B.PERC_PIS
		,B.PERC_COFINS
		, 0 AS CPMF
		, 0 AS IRRF
FROM
	EST_PROD AS PROD INNER JOIN EST_PROD_CPL AS PROD_CPL ON 
	PROD.CD_EMP = PROD_CPL.CD_EMP AND 
	PROD.CD_PROD = PROD_CPL.CD_PROD
	LEFT JOIN EST_PROD_CPL_TRIB_EST PROD_TRIB ON 
	PROD_CPL.CD_EMP = PROD_TRIB.CD_EMP AND	
	PROD_CPL.CD_FILIAL = PROD_TRIB.CD_FILIAL AND 
	PROD_CPL.CD_PROD = PROD_TRIB.CD_PROD AND 
	PROD_TRIB.TP_MOV = 0 AND 
	PROD_TRIB.TP_TRANSA = 1
	LEFT JOIN EST_TRIB TRIB ON 
	PROD_TRIB.CD_TRIB = TRIB.CD_TRIB
	OUTER APPLY UFD_EST_PROD_TRIB_PIS_COFINS(PROD_CPL.CD_EMP,PROD_CPL.CD_FILIAL,0,PROD_CPL.CD_PROD,0,0,0,0,0,0) B



